<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%games}}`.
 */
class m260212_160850_create_games_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%games}}', [
            'id' => $this->primaryKey(),
            'name' => $this->string(255)->notNull(),
            'category' => "ENUM('классические', 'карточные', 'экономические', 'стратегии', 'для детей') NOT NULL",
            'description' => $this->text(),
            'min_players' => $this->integer()->defaultValue(2),
            'max_players' => $this->integer()->defaultValue(10),
            'duration' => $this->integer()->comment('Длительность в минутах'),
            'image' => $this->string(500),
            'is_popular' => $this->boolean()->defaultValue(false),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%games}}');
    }
}
