<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%game_sessions}}`.
 */
class m260212_160909_create_game_sessions_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%game_sessions}}', [
            'id' => $this->primaryKey(),
            'game_id' => $this->integer()->notNull(),
            'date' => $this->date()->notNull(),
            'time' => $this->time()->notNull(),
            'address' => $this->string(500)->notNull(),
            'price' => $this->decimal(10, 2)->notNull(),
            'max_players' => $this->integer()->notNull()->defaultValue(10),
            'current_players' => $this->integer()->notNull()->defaultValue(0),
            'status' => "ENUM('planned', 'active', 'completed', 'cancelled') NOT NULL DEFAULT 'planned'",
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB');

        $this->addForeignKey(
            'fk-game_sessions-game_id',
            '{{%game_sessions}}',
            'game_id',
            '{{%games}}',
            'id',
            'CASCADE',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%game_sessions}}');
    }
}
