<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%insert_game_sessions}}`.
 */
class m260212_161303_create_insert_game_sessions_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $popularGames = (new \yii\db\Query())
            ->select(['id'])
            ->from('{{%games}}')
            ->where(['is_popular' => true])
            ->all();
        
        $gameIds = array_column($popularGames, 'id');
        $time = time();
        
        // Создаем расписание на ближайшие 30 дней
        for ($i = 1; $i <= 30; $i++) {
            $date = date('Y-m-d', strtotime("+$i days"));
            
            foreach ($gameIds as $gameId) {
                // Не все игры каждый день, добавляем рандомно
                if (rand(0, 1)) {
                    $this->insert('{{%game_sessions}}', [
                        'game_id' => $gameId,
                        'date' => $date,
                        'time' => sprintf('%02d:00:00', rand(10, 21)),
                        'address' => 'г. Москва, ул. Тверская, д. 7, коворкинг "Игровой"',
                        'price' => rand(500, 2000),
                        'max_players' => 10,
                        'current_players' => rand(0, 8),
                        'status' => 'planned',
                        'created_at' => $time,
                        'updated_at' => $time,
                    ]);
                }
            }
        }
        
        // Добавляем администратора
        $security = Yii::$app->security;
        $this->insert('{{%users}}', [
            'full_name' => 'Администратор Системы',
            'phone' => '89999999999',
            'email' => 'admin@nastolka.ru',
            'password_hash' => $security->generatePasswordHash('organizator'),
            'auth_key' => $security->generateRandomString(),
            'role' => 'admin',
            'player_status' => 'профессионал',
            'created_at' => $time,
            'updated_at' => $time,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%insert_game_sessions}}');
    }
}
