<?php

/** @var yii\web\View $this */
/** @var string $content */

use yii\helpers\Html;
use yii\helpers\Url;

?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?> | Настолка</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<header class="header">
    <div class="container">
        <div class="header-content">
            <div class="logo">
                <a href="<?= Url::to(['site/index']) ?>" style="font-size: 24px; font-weight: 700; color: #667eea; text-decoration: none;">
                    Настолка
                </a>
            </div>
            
            <nav class="main-nav">
                <ul class="nav-menu">
                    <li><a href="<?= Url::to(['site/index']) ?>">Главная</a></li>
                     <li><a href="<?= Url::to(['site/catalog']) ?>">Каталог</a></li>
                    <li><a href="<?= Url::to(['site/schedule']) ?>">Расписание</a></li>
                    <?php if (Yii::$app->user->isGuest): ?>
                        <li><a href="<?= Url::to(['site/register']) ?>">Регистрация</a></li>
                        <li><a href="<?= Url::to(['site/login']) ?>">Вход</a></li>
                    <?php else: ?>
                         <li><a href="<?= Url::to(['site/my-requests']) ?>">Мои заявки</a></li>
                        <li><a href="<?= Url::to(['site/profile']) ?>">Личный кабинет</a></li>
                        <li>
                            <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                Выход (<?= Html::encode(Yii::$app->user->identity->full_name) ?>)
                            </a>
                            <form id="logout-form" action="<?= Url::to(['site/logout']) ?>" method="POST" style="display: none;">
                                <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                            </form>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </div>
</header>

<main class="main-content">
    <div class="container">
        <?php if (Yii::$app->session->hasFlash('success')): ?>
            <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin-bottom: 20px;">
                <?= Yii::$app->session->getFlash('success') ?>
            </div>
        <?php endif; ?>
        
        <?php if (Yii::$app->session->hasFlash('error')): ?>
            <div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin-bottom: 20px;">
                <?= Yii::$app->session->getFlash('error') ?>
            </div>
        <?php endif; ?>
        
        <?= $content ?>
    </div>
</main>

<footer style="background: #1a1a2e; color: white; padding: 40px 0; margin-top: 50px;">
    <div class="container">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 40px;">
            <div>
                <h3 style="color: #667eea; margin-bottom: 20px;">Настолка</h3>
                <p style="color: #b0b0b0;">Организация коллективных настольных игр для любой компании.</p>
            </div>
            
            <div>
                <h4 style="color: white; margin-bottom: 20px;">Меню</h4>
                <ul style="list-style: none; padding: 0;">
                    <li style="margin-bottom: 10px;"><a href="<?= Url::to(['site/index']) ?>" style="color: #b0b0b0; text-decoration: none;">Главная</a></li>
                    <li style="margin-bottom: 10px;"><a href="<?= Url::to(['site/register']) ?>" style="color: #b0b0b0; text-decoration: none;">Регистрация</a></li>
                    <li style="margin-bottom: 10px;"><a href="<?= Url::to(['site/login']) ?>" style="color: #b0b0b0; text-decoration: none;">Вход</a></li>
                </ul>
            </div>
            
            <div>
                <h4 style="color: white; margin-bottom: 20px;">Контакты</h4>
                <address style="color: #b0b0b0;">
                    <p style="margin-bottom: 10px;">г. Москва, ул. Тверская, д. 7</p>
                    <p style="margin-bottom: 10px;">8(999)999-99-99</p>
                    <p style="margin-bottom: 10px;">info@nastolka.ru</p>
                </address>
            </div>
        </div>
        
        <div style="text-align: center; padding-top: 20px; margin-top: 20px; border-top: 1px solid rgba(255,255,255,0.1); color: #b0b0b0;">
            <p>&copy; <?= date('Y') ?> Настолка. Все права защищены.</p>
        </div>
    </div>
</footer>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Montserrat', sans-serif;
    line-height: 1.6;
    color: #333;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
}

.header {
    background: white;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    position: sticky;
    top: 0;
    z-index: 1000;
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 15px 0;
}

.nav-menu {
    display: flex;
    list-style: none;
    margin: 0;
    padding: 0;
}

.nav-menu li {
    margin-left: 30px;
}

.nav-menu a {
    text-decoration: none;
    color: #333;
    font-weight: 500;
    transition: color 0.3s;
}

.nav-menu a:hover {
    color: #667eea;
}

.main-content {
    min-height: calc(100vh - 300px);
    background: white;
    padding: 40px 0;
    margin: 30px 0;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
}

@media (max-width: 768px) {
    .nav-menu {
        flex-direction: column;
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: white;
        padding: 20px;
        display: none;
    }
    
    .nav-menu.active {
        display: flex;
    }
    
    .nav-menu li {
        margin: 10px 0;
    }
}
</style>

<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>