<?php
use yii\helpers\Html;
use yii\helpers\Url;
$this->title = 'Настолка - настольные игры для любой компании';
?>

<div class="home-page">
    <!-- Hero Section -->
    <section class="hero">
        <div class="hero-content">
            <div class="hero-text animate-fade-in">
                <h1 class="hero-title">Настольные игры для любой компании</h1>
                <p class="hero-subtitle">Присоединяйтесь к нашему игровому сообществу. Новые знакомства, любимые игры и море эмоций!</p>
                
                <?php if (Yii::$app->user->isGuest): ?>
                    <div class="hero-buttons">
                        <a href="<?= Url::to(['site/register']) ?>" class="btn btn-primary btn-large">
                            <i class="fas fa-user-plus"></i>
                            Начать играть
                        </a>
                        <a href="<?= Url::to(['site/login']) ?>" class="btn btn-outline btn-large">
                            <i class="fas fa-sign-in-alt"></i>
                            Войти
                        </a>
                    </div>
                <?php else: ?>
                    <div class="hero-buttons">
                        <a href="<?= Url::to(['site/profile']) ?>" class="btn btn-primary btn-large">
                            <i class="fas fa-user"></i>
                            Личный кабинет
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="hero-image animate-slide-in">
                <div class="floating-cubes">
                    <i class="fas fa-cube cube1"></i>
                    <i class="fas fa-cube cube2"></i>
                    <i class="fas fa-cube cube3"></i>
                    <i class="fas fa-dice-d20 dice1"></i>
                    <i class="fas fa-dice-d6 dice2"></i>
                    <i class="fas fa-chess-queen chess1"></i>
                    <i class="fas fa-chess-knight chess2"></i>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="features">
        <div class="container">
            <div class="section-header">
                <span class="section-badge">Почему мы</span>
                <h2 class="section-title">Преимущества игры с нами</h2>
                <p class="section-subtitle">Создаем уютную атмосферу для вашего досуга</p>
            </div>
            
            <div class="features-grid">
                <div class="feature-card animate-on-scroll">
                    <div class="feature-icon">
                        <i class="fas fa-dice-d20"></i>
                    </div>
                    <h3>Более 50 игр</h3>
                    <p>Огромный выбор настольных игр на любой вкус: от классики до новинок</p>
                </div>
                
                <div class="feature-card animate-on-scroll">
                    <div class="feature-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3>Дружное комьюнити</h3>
                    <p>Тысячи активных игроков, всегда рады новым участникам</p>
                </div>
                
                <div class="feature-card animate-on-scroll">
                    <div class="feature-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <h3>Уютные локации</h3>
                    <p>Комфортные пространства в центре города для приятной игры</p>
                </div>
                
                <div class="feature-card animate-on-scroll">
                    <div class="feature-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3>Гибкий график</h3>
                    <p>Игры каждый день, выбирайте удобное время и дату</p>
                </div>
                
                <div class="feature-card animate-on-scroll">
                    <div class="feature-icon">
                        <i class="fas fa-gift"></i>
                    </div>
                    <h3>Акции и скидки</h3>
                    <p>Постоянные акции для новичков и постоянных игроков</p>
                </div>
                
                <div class="feature-card animate-on-scroll">
                    <div class="feature-icon">
                        <i class="fas fa-crown"></i>
                    </div>
                    <h3>Профессиональные ведущие</h3>
                    <p>Опытные гейм-мастера помогут освоить любую игру</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta">
        <div class="container">
            <div class="cta-content">
                <h2>Готовы к игре?</h2>
                <p>Присоединяйтесь к нам сегодня и получите скидку 20% на первую игру</p>
                <?php if (Yii::$app->user->isGuest): ?>
                    <a href="<?= Url::to(['site/register']) ?>" class="btn btn-light btn-large">
                        Зарегистрироваться
                        <i class="fas fa-arrow-right"></i>
                    </a>
                <?php else: ?>
                    <a href="<?= Url::to(['site/profile']) ?>" class="btn btn-light btn-large">
                        Перейти в профиль
                        <i class="fas fa-arrow-right"></i>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </section>
</div>

<style>
.home-page {
    overflow-x: hidden;
}

/* Container */
.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
}

/* Hero Section */
.hero {
    min-height: 600px;
    display: flex;
    align-items: center;
    padding: 80px 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    position: relative;
    overflow: hidden;
    border-radius: 0 0 50px 50px;
    margin-bottom: 80px;
}

.hero:before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><rect x="0" y="0" width="60" height="60" fill="none"/><circle cx="30" cy="30" r="2" fill="rgba(255,255,255,0.1)"/></svg>');
    opacity: 0.5;
}

.hero-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 50px;
    align-items: center;
    position: relative;
    z-index: 1;
}

.hero-text {
    color: white;
}

.hero-title {
    font-size: 48px;
    font-weight: 800;
    line-height: 1.2;
    margin-bottom: 25px;
    animation: fadeInLeft 1s ease;
}

.hero-subtitle {
    font-size: 20px;
    opacity: 0.95;
    margin-bottom: 35px;
    line-height: 1.6;
    animation: fadeInLeft 1s ease 0.2s both;
}

.hero-buttons {
    display: flex;
    gap: 20px;
    animation: fadeInLeft 1s ease 0.4s both;
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    padding: 14px 32px;
    font-size: 16px;
    font-weight: 600;
    text-decoration: none;
    border-radius: 50px;
    transition: all 0.3s;
    border: none;
    cursor: pointer;
}

.btn-large {
    padding: 16px 40px;
    font-size: 18px;
}

.btn-primary {
    background: white;
    color: #667eea;
}

.btn-primary:hover {
    transform: translateY(-3px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
    background: white;
    color: #764ba2;
}

.btn-outline {
    background: transparent;
    color: white;
    border: 2px solid white;
}

.btn-outline:hover {
    background: white;
    color: #667eea;
    transform: translateY(-3px);
}

.btn-light {
    background: white;
    color: #667eea;
}

.btn-light:hover {
    background: rgba(255,255,255,0.9);
    transform: translateY(-3px);
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.2);
}

/* Hero Image & Animation */
.hero-image {
    position: relative;
    height: 400px;
    animation: fadeInRight 1s ease;
}

.floating-cubes {
    position: relative;
    width: 100%;
    height: 100%;
}

.floating-cubes i {
    position: absolute;
    color: rgba(255, 255, 255, 0.3);
    font-size: 60px;
}

.cube1 {
    top: 20%;
    left: 20%;
    animation: float 6s ease-in-out infinite;
}

.cube2 {
    top: 50%;
    right: 20%;
    animation: float 7s ease-in-out infinite 0.5s;
    font-size: 80px;
}

.cube3 {
    bottom: 20%;
    left: 40%;
    animation: float 8s ease-in-out infinite 1s;
    font-size: 50px;
}

.dice1 {
    top: 30%;
    right: 30%;
    animation: spin 10s linear infinite;
    font-size: 70px;
}

.dice2 {
    bottom: 30%;
    right: 40%;
    animation: spin 12s linear infinite reverse;
    font-size: 55px;
}

.chess1 {
    top: 15%;
    right: 15%;
    animation: float 9s ease-in-out infinite 1.5s;
    font-size: 65px;
}

.chess2 {
    bottom: 15%;
    left: 15%;
    animation: float 7s ease-in-out infinite 0.8s;
    font-size: 75px;
}

@keyframes float {
    0%, 100% { transform: translateY(0) rotate(0deg); }
    50% { transform: translateY(-20px) rotate(5deg); }
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

/* Features Section */
.features {
    padding: 80px 0;
    background: white;
}

.section-header {
    text-align: center;
    max-width: 600px;
    margin: 0 auto 60px;
}

.section-badge {
    display: inline-block;
    padding: 8px 20px;
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    color: #667eea;
    border-radius: 50px;
    font-size: 14px;
    font-weight: 600;
    margin-bottom: 20px;
}

.section-title {
    font-size: 36px;
    color: #333;
    margin-bottom: 15px;
    font-weight: 700;
}

.section-subtitle {
    font-size: 18px;
    color: #666;
    line-height: 1.6;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 30px;
}

.feature-card {
    background: white;
    padding: 40px 30px;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.05);
    transition: all 0.3s;
    text-align: center;
    border: 1px solid rgba(102, 126, 234, 0.1);
}

.feature-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 20px 60px rgba(102, 126, 234, 0.2);
    border-color: transparent;
}

.feature-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 25px;
    font-size: 35px;
    color: #667eea;
    transition: all 0.3s;
}

.feature-card:hover .feature-icon {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    transform: rotate(10deg);
}

.feature-card h3 {
    font-size: 22px;
    margin-bottom: 15px;
    color: #333;
}

.feature-card p {
    color: #666;
    line-height: 1.6;
    margin: 0;
}

/* CTA Section */
.cta {
    padding: 100px 0;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 50px 50px 0 0;
    margin-top: 80px;
    position: relative;
    overflow: hidden;
}

.cta:before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"><rect x="0" y="0" width="60" height="60" fill="none"/><circle cx="30" cy="30" r="2" fill="rgba(255,255,255,0.1)"/></svg>');
    opacity: 0.5;
}

.cta-content {
    position: relative;
    z-index: 1;
    text-align: center;
    color: white;
    max-width: 700px;
    margin: 0 auto;
}

.cta h2 {
    font-size: 48px;
    font-weight: 800;
    margin-bottom: 20px;
}

.cta p {
    font-size: 20px;
    margin-bottom: 40px;
    opacity: 0.95;
}

/* Animations */
@keyframes fadeInLeft {
    from {
        opacity: 0;
        transform: translateX(-30px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

@keyframes fadeInRight {
    from {
        opacity: 0;
        transform: translateX(30px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.animate-fade-in {
    animation: fadeInLeft 1s ease;
}

.animate-slide-in {
    animation: fadeInRight 1s ease;
}

.animate-on-scroll {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.8s ease;
}

.animate-on-scroll.animated {
    opacity: 1;
    transform: translateY(0);
}

/* Responsive */
@media (max-width: 992px) {
    .hero-content {
        grid-template-columns: 1fr;
        text-align: center;
    }
    
    .hero-buttons {
        justify-content: center;
    }
    
    .hero-image {
        display: none;
    }
    
    .hero-title {
        font-size: 40px;
    }
    
    .cta h2 {
        font-size: 36px;
    }
}

@media (max-width: 768px) {
    .hero {
        min-height: 500px;
        padding: 60px 0;
    }
    
    .hero-title {
        font-size: 32px;
    }
    
    .hero-subtitle {
        font-size: 18px;
    }
    
    .features-grid {
        grid-template-columns: 1fr;
    }
    
    .section-title {
        font-size: 28px;
    }
    
    .cta h2 {
        font-size: 28px;
    }
    
    .btn-large {
        padding: 14px 30px;
        font-size: 16px;
    }
}

@media (max-width: 480px) {
    .hero-buttons {
        flex-direction: column;
    }
    
    .hero-title {
        font-size: 28px;
    }
    
    .feature-card {
        padding: 30px 20px;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Анимация при скролле
    const animateElements = document.querySelectorAll('.animate-on-scroll');
    
    function checkScroll() {
        animateElements.forEach(element => {
            const elementTop = element.getBoundingClientRect().top;
            const windowHeight = window.innerHeight;
            
            if (elementTop < windowHeight - 100) {
                element.classList.add('animated');
            }
        });
    }
    
    window.addEventListener('scroll', checkScroll);
    checkScroll(); // Проверяем при загрузке
});
</script>