<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\Url;
$this->title = 'Вход в систему';
?>

<div class="auth-page">
    <div class="auth-container">
        <div class="auth-header">
            <div class="auth-logo">
                <i class="fas fa-dice-d6"></i>
            </div>
            <h1>Добро пожаловать!</h1>
            <p>Войдите в свой аккаунт</p>
        </div>
        
        <div class="auth-form">
            <?php $form = ActiveForm::begin([
                'id' => 'login-form',
                'method' => 'post',
                'options' => ['class' => 'form']
            ]); ?>
            
            <div class="form-group">
                <div class="input-icon">
                    <i class="fas fa-phone"></i>
                    <?= $form->field($model, 'phone')->textInput([
                        'placeholder' => '8(999)999-99-99',
                        'id' => 'phone-mask',
                        'class' => 'form-control',
                        'autocomplete' => 'tel'
                    ])->label(false) ?>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <?= $form->field($model, 'password')->passwordInput([
                        'placeholder' => 'Введите пароль',
                        'class' => 'form-control',
                        'autocomplete' => 'current-password'
                    ])->label(false) ?>
                </div>
            </div>
            
            <div class="form-check">
                <?= $form->field($model, 'rememberMe')->checkbox([
                    'template' => "{input} {label}",
                    'class' => 'checkbox',
                    'id' => 'rememberMe'
                ]) ?>
                <label for="rememberMe" class="checkbox-label">
                    Запомнить меня
                </label>
            </div>
            
            <div class="form-group">
                <?= Html::submitButton('Войти', [
                    'class' => 'btn btn-primary btn-block',
                    'name' => 'login-button'
                ]) ?>
            </div>
            
            <div class="auth-footer">
                <p>Еще нет аккаунта? <a href="<?= Url::to(['site/register']) ?>">Зарегистрироваться</a></p>
            </div>
            
            <?php ActiveForm::end(); ?>
        </div>
        
        <!-- Блок с демо-доступом в стиле регистрации -->
        <div class="demo-card">
            <div class="demo-card-icon">
                <i class="fas fa-info-circle"></i>
            </div>
            <div class="demo-card-content">
                <strong>Демо-доступ:</strong>
                <span>8(999)999-99-99 / organizator</span>
            </div>
        </div>
    </div>
</div>

<style>
/* Наследуем все стили из регистрации */
.auth-page {
    min-height: calc(100vh - 200px);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 40px 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.auth-container {
    max-width: 500px;
    width: 100%;
    background: white;
    border-radius: 20px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    overflow: hidden;
    animation: slideUp 0.5s ease;
}

@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.auth-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 40px 30px;
    text-align: center;
    color: white;
}

.auth-logo {
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
    font-size: 40px;
    color: white;
    backdrop-filter: blur(10px);
}

.auth-header h1 {
    margin: 0 0 10px;
    font-size: 28px;
    font-weight: 600;
}

.auth-header p {
    margin: 0;
    opacity: 0.9;
    font-size: 16px;
}

.auth-form {
    padding: 40px;
    background: white;
}

.form-group {
    margin-bottom: 20px;
}

.input-icon {
    position: relative;
}

.input-icon i {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    color: #999;
    font-size: 18px;
    transition: color 0.3s;
}

.form-control {
    width: 100%;
    padding: 14px 20px 14px 50px;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    font-size: 15px;
    font-family: 'Montserrat', sans-serif;
    transition: all 0.3s;
    background: #f8f9fa;
}

.form-control:focus {
    border-color: #667eea;
    background: white;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
    outline: none;
}

.form-control:focus + i {
    color: #667eea;
}

.form-check {
    display: flex;
    align-items: flex-start;
    margin: 25px 0;
    gap: 12px;
}

.checkbox {
    width: 20px;
    height: 20px;
    margin-top: 2px;
    cursor: pointer;
    accent-color: #667eea;
}

.checkbox-label {
    font-size: 14px;
    color: #666;
    line-height: 1.5;
    cursor: pointer;
}

.btn {
    display: inline-block;
    padding: 14px 28px;
    font-size: 16px;
    font-weight: 600;
    text-align: center;
    text-decoration: none;
    border-radius: 12px;
    border: none;
    cursor: pointer;
    transition: all 0.3s;
    font-family: 'Montserrat', sans-serif;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    width: 100%;
    position: relative;
    overflow: hidden;
}

.btn-primary:before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
}

.btn-primary:hover:before {
    left: 100%;
}

.btn-block {
    display: block;
    width: 100%;
}

.auth-footer {
    text-align: center;
    margin-top: 30px;
    padding-top: 20px;
    border-top: 1px solid #e0e0e0;
}

.auth-footer p {
    margin: 0;
    color: #666;
}

.auth-footer a {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
    transition: color 0.3s;
}

.auth-footer a:hover {
    color: #764ba2;
    text-decoration: underline;
}

/* Стили для демо-карточки в стиле регистрации */
.demo-card {
    margin: 0 40px 40px 40px;
    padding: 20px;
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.08) 0%, rgba(118, 75, 162, 0.08) 100%);
    border-radius: 16px;
    display: flex;
    align-items: center;
    gap: 16px;
    border: 1px solid rgba(102, 126, 234, 0.2);
    transition: all 0.3s;
}

.demo-card:hover {
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.12) 0%, rgba(118, 75, 162, 0.12) 100%);
    border-color: rgba(102, 126, 234, 0.3);
    transform: translateY(-2px);
}

.demo-card-icon {
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 22px;
    flex-shrink: 0;
}

.demo-card-content {
    flex: 1;
    color: #333;
    font-size: 14px;
    line-height: 1.5;
}

.demo-card-content strong {
    color: #667eea;
    display: block;
    margin-bottom: 6px;
    font-size: 15px;
}

.demo-card-content span {
    display: inline-block;
    background: rgba(102, 126, 234, 0.1);
    padding: 6px 14px;
    border-radius: 50px;
    font-family: 'Courier New', monospace;
    font-size: 14px;
    color: #667eea;
    font-weight: 600;
    border: 1px solid rgba(102, 126, 234, 0.2);
}

/* Стили для ошибок валидации */
.has-error .form-control {
    border-color: #dc3545;
    background: #fff8f8;
}

.has-error .help-block {
    color: #dc3545;
    font-size: 13px;
    margin-top: 8px;
    margin-left: 15px;
}

/* Анимация загрузки */
.btn-loading {
    position: relative;
    pointer-events: none;
    opacity: 0.8;
}

.btn-loading:after {
    content: '';
    position: absolute;
    width: 20px;
    height: 20px;
    top: 50%;
    left: 50%;
    margin-left: -10px;
    margin-top: -10px;
    border: 2px solid rgba(255,255,255,0.3);
    border-radius: 50%;
    border-top-color: white;
    animation: spin 0.8s infinite linear;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

/* Адаптивность */
@media (max-width: 768px) {
    .auth-container {
        max-width: 100%;
    }
    
    .auth-header {
        padding: 30px 20px;
    }
    
    .auth-form {
        padding: 30px 20px;
    }
    
    .auth-header h1 {
        font-size: 24px;
    }
    
    .demo-card {
        margin: 0 20px 30px 20px;
        padding: 16px;
    }
    
    .demo-card-icon {
        width: 44px;
        height: 44px;
        font-size: 20px;
    }
    
    .demo-card-content span {
        font-size: 12px;
        padding: 5px 12px;
        word-break: break-all;
    }
}

@media (max-width: 480px) {
    .auth-header {
        padding: 25px 15px;
    }
    
    .auth-logo {
        width: 70px;
        height: 70px;
        font-size: 35px;
    }
    
    .auth-header h1 {
        font-size: 22px;
    }
    
    .auth-form {
        padding: 25px 15px;
    }
    
    .form-control {
        padding: 12px 20px 12px 45px;
        font-size: 14px;
    }
    
    .demo-card {
        flex-direction: column;
        text-align: center;
        margin: 0 15px 25px 15px;
    }
    
    .demo-card-content strong {
        margin-bottom: 8px;
    }
}
</style>

<script>
// Маска для телефона
document.addEventListener('DOMContentLoaded', function() {
    const phoneInput = document.getElementById('phone-mask');
    if (phoneInput) {
        phoneInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 11) value = value.substring(0, 11);
            
            let formatted = '';
            if (value.length > 0) {
                if (value[0] !== '8' && value[0] !== '7') {
                    value = '8' + value;
                }
                formatted = '8(' + value.substring(1, 4);
            }
            if (value.length >= 5) {
                formatted += ')' + value.substring(4, 7);
            }
            if (value.length >= 8) {
                formatted += '-' + value.substring(7, 9);
            }
            if (value.length >= 10) {
                formatted += '-' + value.substring(9, 11);
            }
            e.target.value = formatted;
        });
    }

    // Анимация кнопки при отправке
    const form = document.getElementById('login-form');
    if (form) {
        form.addEventListener('submit', function(e) {
            const btn = this.querySelector('button[type="submit"]');
            btn.classList.add('btn-loading');
        });
    }
});
</script>