<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
$this->title = 'Регистрация';
?>

<div class="auth-page">
    <div class="auth-container">
        <div class="auth-header">
            <div class="auth-logo">
                <i class="fas fa-dice-d20"></i>
            </div>
            <h1>Создать аккаунт</h1>
            <p>Присоединяйтесь к игровому сообществу</p>
        </div>
        
        <div class="auth-form">
            <?php $form = ActiveForm::begin([
                'id' => 'register-form',
                'method' => 'post',
                'options' => ['class' => 'form']
            ]); ?>
            
            <div class="form-group">
                <div class="input-icon">
                    <i class="fas fa-user"></i>
                    <?= $form->field($model, 'full_name')->textInput([
                        'placeholder' => 'Иванов Иван Иванович',
                        'class' => 'form-control',
                        'autocomplete' => 'name'
                    ])->label(false) ?>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-icon">
                    <i class="fas fa-phone"></i>
                    <?= $form->field($model, 'phone')->textInput([
                        'placeholder' => '8(999)999-99-99',
                        'id' => 'phone-mask',
                        'class' => 'form-control',
                        'autocomplete' => 'tel'
                    ])->label(false) ?>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-icon">
                    <i class="fas fa-envelope"></i>
                    <?= $form->field($model, 'email')->textInput([
                        'placeholder' => 'example@mail.ru',
                        'type' => 'email',
                        'class' => 'form-control',
                        'autocomplete' => 'email'
                    ])->label(false) ?>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <?= $form->field($model, 'password')->passwordInput([
                        'placeholder' => 'Минимум 8 символов',
                        'class' => 'form-control',
                        'autocomplete' => 'new-password'
                    ])->label(false) ?>
                </div>
            </div>
            
            <div class="form-group">
                <div class="input-icon">
                    <i class="fas fa-lock"></i>
                    <?= $form->field($model, 'password_repeat')->passwordInput([
                        'placeholder' => 'Повторите пароль',
                        'class' => 'form-control',
                        'autocomplete' => 'new-password'
                    ])->label(false) ?>
                </div>
            </div>
            
            <div class="form-check">
                <?= $form->field($model, 'agree_rules')->checkbox([
                    'template' => "{input} {label}",
                    'class' => 'checkbox',
                    'id' => 'agree_rules'
                ]) ?>
                <label for="agree_rules" class="checkbox-label">
                    Я принимаю <a href="#" onclick="openRulesModal(event)">условия использования</a> и <a href="#" onclick="openPrivacyModal(event)">политику конфиденциальности</a>
                </label>
            </div>
            
            <div class="form-group">
                <?= Html::submitButton('Создать аккаунт', [
                    'class' => 'btn btn-primary btn-block',
                    'name' => 'register-button'
                ]) ?>
            </div>
            
            <div class="auth-footer">
                <p>Уже есть аккаунт? <a href="<?= yii\helpers\Url::to(['site/login']) ?>">Войти</a></p>
            </div>
            
            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>

<!-- Модальное окно с правилами использования -->
<div id="rulesModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Условия использования</h3>
            <button class="modal-close" onclick="closeRulesModal()">&times;</button>
        </div>
        <div class="modal-body">
            <div class="rules-section">
                <h4>1. Общие положения</h4>
                <p>Регистрируясь на сайте, вы соглашаетесь с условиями использования сервиса «Настолка».</p>
                
                <h4>2. Правила поведения</h4>
                <p>Вы обязуетесь соблюдать правила поведения во время игр, уважать других участников и администраторов.</p>
                
                <h4>3. Отмена записи</h4>
                <p>Отмена записи на игру возможна не позднее, чем за 24 часа до начала мероприятия.</p>
                
                <h4>4. Ответственность</h4>
                <p>Администрация не несет ответственности за сохранность личных вещей участников.</p>
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" onclick="closeRulesModal()">Закрыть</button>
        </div>
    </div>
</div>

<!-- Модальное окно с политикой конфиденциальности -->
<div id="privacyModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3>Политика конфиденциальности</h3>
            <button class="modal-close" onclick="closePrivacyModal()">&times;</button>
        </div>
        <div class="modal-body">
            <div class="rules-section">
                <h4>1. Сбор персональных данных</h4>
                <p>Мы собираем только необходимые данные: ФИО, телефон и email для организации игр и связи с вами.</p>
                
                <h4>2. Использование данных</h4>
                <p>Ваши данные используются исключительно для функционирования сервиса и не передаются третьим лицам.</p>
                
                <h4>3. Защита данных</h4>
                <p>Все персональные данные хранятся в зашифрованном виде и защищены от несанкционированного доступа.</p>
                
                <h4>4. Удаление данных</h4>
                <p>Вы можете запросить удаление своих данных в любой момент, обратившись к администратору.</p>
            </div>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" onclick="closePrivacyModal()">Закрыть</button>
        </div>
    </div>
</div>

<style>
/* Общие стили для страницы авторизации */
.auth-page {
    min-height: calc(100vh - 200px);
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 40px 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.auth-container {
    max-width: 500px;
    width: 100%;
    background: white;
    border-radius: 20px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    overflow: hidden;
    animation: slideUp 0.5s ease;
}

@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.auth-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 40px 30px;
    text-align: center;
    color: white;
}

.auth-logo {
    width: 80px;
    height: 80px;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
    font-size: 40px;
    color: white;
    backdrop-filter: blur(10px);
}

.auth-header h1 {
    margin: 0 0 10px;
    font-size: 28px;
    font-weight: 600;
}

.auth-header p {
    margin: 0;
    opacity: 0.9;
    font-size: 16px;
}

.auth-form {
    padding: 40px;
    background: white;
}

.form-group {
    margin-bottom: 20px;
}

.input-icon {
    position: relative;
}

.input-icon i {
    position: absolute;
    left: 15px;
    top: 50%;
    transform: translateY(-50%);
    color: #999;
    font-size: 18px;
    transition: color 0.3s;
}

.form-control {
    width: 100%;
    padding: 14px 20px 14px 50px;
    border: 2px solid #e0e0e0;
    border-radius: 12px;
    font-size: 15px;
    font-family: 'Montserrat', sans-serif;
    transition: all 0.3s;
    background: #f8f9fa;
}

.form-control:focus {
    border-color: #667eea;
    background: white;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
    outline: none;
}

.form-control:focus + i {
    color: #667eea;
}

.form-check {
    display: flex;
    align-items: flex-start;
    margin: 25px 0;
    gap: 12px;
}

.checkbox {
    width: 20px;
    height: 20px;
    margin-top: 2px;
    cursor: pointer;
    accent-color: #667eea;
}

.checkbox-label {
    font-size: 14px;
    color: #666;
    line-height: 1.5;
    cursor: pointer;
}

.checkbox-label a {
    color: #667eea;
    text-decoration: none;
    font-weight: 500;
    transition: color 0.3s;
}

.checkbox-label a:hover {
    color: #764ba2;
    text-decoration: underline;
}

.btn {
    display: inline-block;
    padding: 14px 28px;
    font-size: 16px;
    font-weight: 600;
    text-align: center;
    text-decoration: none;
    border-radius: 12px;
    border: none;
    cursor: pointer;
    transition: all 0.3s;
    font-family: 'Montserrat', sans-serif;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    width: 100%;
    position: relative;
    overflow: hidden;
}

.btn-primary:before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
}

.btn-primary:hover:before {
    left: 100%;
}

.btn-block {
    display: block;
    width: 100%;
}

.auth-footer {
    text-align: center;
    margin-top: 30px;
    padding-top: 20px;
    border-top: 1px solid #e0e0e0;
}

.auth-footer p {
    margin: 0;
    color: #666;
}

.auth-footer a {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
    transition: color 0.3s;
}

.auth-footer a:hover {
    color: #764ba2;
    text-decoration: underline;
}

/* Модальные окна */
.modal {
    display: none;
    position: fixed;
    z-index: 9999;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    backdrop-filter: blur(5px);
    align-items: center;
    justify-content: center;
}

.modal.show {
    display: flex;
}

.modal-content {
    background: white;
    width: 90%;
    max-width: 600px;
    border-radius: 20px;
    box-shadow: 0 25px 50px rgba(0, 0, 0, 0.3);
    animation: modalSlideIn 0.3s;
}

@keyframes modalSlideIn {
    from {
        transform: translateY(-50px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

.modal-header {
    padding: 25px 30px;
    border-bottom: 1px solid #e0e0e0;
    display: flex;
    justify-content: space-between;
    align-items: center;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border-radius: 20px 20px 0 0;
}

.modal-header h3 {
    margin: 0;
    font-size: 20px;
}

.modal-close {
    background: none;
    border: none;
    color: white;
    font-size: 28px;
    cursor: pointer;
    opacity: 0.8;
    transition: opacity 0.3s;
}

.modal-close:hover {
    opacity: 1;
}

.modal-body {
    padding: 30px;
    max-height: 70vh;
    overflow-y: auto;
}

.modal-footer {
    padding: 20px 30px;
    border-top: 1px solid #e0e0e0;
    text-align: right;
}

.btn-secondary {
    background: #6c757d;
    color: white;
    padding: 10px 25px;
}

.btn-secondary:hover {
    background: #5a6268;
}

.rules-section h4 {
    color: #667eea;
    margin: 25px 0 10px;
    font-size: 18px;
}

.rules-section h4:first-child {
    margin-top: 0;
}

.rules-section p {
    color: #666;
    line-height: 1.6;
    margin-bottom: 20px;
}

/* Адаптивность */
@media (max-width: 768px) {
    .auth-container {
        max-width: 100%;
    }
    
    .auth-header {
        padding: 30px 20px;
    }
    
    .auth-form {
        padding: 30px 20px;
    }
    
    .auth-header h1 {
        font-size: 24px;
    }
}

/* Стили для ошибок валидации */
.has-error .form-control {
    border-color: #dc3545;
    background: #fff8f8;
}

.has-error .help-block {
    color: #dc3545;
    font-size: 13px;
    margin-top: 8px;
    margin-left: 15px;
}

/* Анимация загрузки */
.btn-loading {
    position: relative;
    pointer-events: none;
    opacity: 0.8;
}

.btn-loading:after {
    content: '';
    position: absolute;
    width: 20px;
    height: 20px;
    top: 50%;
    left: 50%;
    margin-left: -10px;
    margin-top: -10px;
    border: 2px solid rgba(255,255,255,0.3);
    border-radius: 50%;
    border-top-color: white;
    animation: spin 0.8s infinite linear;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
</style>

<script>
// Маска для телефона
document.addEventListener('DOMContentLoaded', function() {
    const phoneInput = document.getElementById('phone-mask');
    if (phoneInput) {
        phoneInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value.length > 11) value = value.substring(0, 11);
            
            let formatted = '';
            if (value.length > 0) {
                if (value[0] !== '8' && value[0] !== '7') {
                    value = '8' + value;
                }
                formatted = '8(' + value.substring(1, 4);
            }
            if (value.length >= 5) {
                formatted += ')' + value.substring(4, 7);
            }
            if (value.length >= 8) {
                formatted += '-' + value.substring(7, 9);
            }
            if (value.length >= 10) {
                formatted += '-' + value.substring(9, 11);
            }
            e.target.value = formatted;
        });
    }

    // Анимация кнопки при отправке
    const form = document.getElementById('register-form');
    if (form) {
        form.addEventListener('submit', function(e) {
            const btn = this.querySelector('button[type="submit"]');
            btn.classList.add('btn-loading');
        });
    }
});

// Модальные окна
function openRulesModal(e) {
    e.preventDefault();
    document.getElementById('rulesModal').classList.add('show');
    document.body.style.overflow = 'hidden';
}

function closeRulesModal() {
    document.getElementById('rulesModal').classList.remove('show');
    document.body.style.overflow = '';
}

function openPrivacyModal(e) {
    e.preventDefault();
    document.getElementById('privacyModal').classList.add('show');
    document.body.style.overflow = 'hidden';
}

function closePrivacyModal() {
    document.getElementById('privacyModal').classList.remove('show');
    document.body.style.overflow = '';
}

// Закрытие модальных окон по клику вне
window.addEventListener('click', function(e) {
    const rulesModal = document.getElementById('rulesModal');
    const privacyModal = document.getElementById('privacyModal');
    
    if (e.target === rulesModal) {
        closeRulesModal();
    }
    if (e.target === privacyModal) {
        closePrivacyModal();
    }
});

// Закрытие по Escape
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeRulesModal();
        closePrivacyModal();
    }
});
</script>