<?php
use yii\helpers\Html;
use yii\helpers\Url;
$this->title = 'Расписание игр';
?>

<div class="schedule-page">
    <div class="schedule-header">
        <div class="container">
            <h1 class="schedule-title">Расписание игр</h1>
            <p class="schedule-subtitle">Ближайшие игровые сессии на этот месяц</p>
        </div>
    </div>

    <div class="container">
        <?php if (empty($sessions)): ?>
            <div class="empty-state">
                <div class="empty-state-icon">
                    <i class="fas fa-calendar-times"></i>
                </div>
                <h2>На ближайшее время игр нет</h2>
                <p>Загляните позже - мы регулярно добавляем новые сессии</p>
                <a href="<?= Url::to(['site/catalog']) ?>" class="btn btn-primary">
                    <i class="fas fa-gamepad"></i>
                    Смотреть каталог игр
                </a>
            </div>
        <?php else: ?>
            <div class="schedule-grid">
                <?php foreach ($sessions as $session): ?>
                    <div class="session-card">
                        <div class="session-date">
                            <span class="day"><?= date('d', strtotime($session->date)) ?></span>
                            <span class="month"><?= date('m', strtotime($session->date)) ?></span>
                        </div>
                        
                        <div class="session-content">
                            <div class="session-header">
                                <h3 class="session-title"><?= Html::encode($session->game->name) ?></h3>
                                <span class="session-category"><?= $session->game->getCategoryLabel() ?></span>
                            </div>
                            
                            <div class="session-details">
                                <div class="session-detail">
                                    <i class="fas fa-clock"></i>
                                    <span><?= date('H:i', strtotime($session->time)) ?></span>
                                </div>
                                <div class="session-detail">
                                    <i class="fas fa-map-marker-alt"></i>
                                    <span><?= Html::encode($session->address) ?></span>
                                </div>
                                <div class="session-detail">
                                    <i class="fas fa-tag"></i>
                                    <span class="price"><?= number_format($session->price, 0, '', ' ') ?> ₽</span>
                                </div>
                                <div class="session-detail">
                                    <i class="fas fa-users"></i>
                                    <span>Свободно: <?= $session->availableSlots ?> / <?= $session->max_players ?></span>
                                </div>
                            </div>
                            
                            <div class="session-actions">
                                <?php if ($session->isAvailable()): ?>
                                    <?php if (Yii::$app->user->isGuest): ?>
                                        <a href="<?= Url::to(['site/login']) ?>" class="btn btn-primary">
                                            <i class="fas fa-sign-in-alt"></i>
                                            Войдите для записи
                                        </a>
                                    <?php else: ?>
                                        <a href="<?= Url::to(['site/create-request', 'session_id' => $session->id]) ?>" class="btn btn-primary">
                                            <i class="fas fa-check-circle"></i>
                                            Записаться
                                        </a>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <button class="btn btn-secondary" disabled>
                                        <i class="fas fa-times-circle"></i>
                                        Нет мест
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.schedule-page {
    padding-bottom: 60px;
}

.schedule-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 60px 0;
    margin-bottom: 40px;
    border-radius: 0 0 50px 50px;
    color: white;
    text-align: center;
}

.schedule-title {
    font-size: 42px;
    font-weight: 800;
    margin-bottom: 15px;
}

.schedule-subtitle {
    font-size: 18px;
    opacity: 0.95;
    max-width: 600px;
    margin: 0 auto;
}

/* Empty State */
.empty-state {
    text-align: center;
    padding: 80px 20px;
    background: white;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.05);
}

.empty-state-icon {
    width: 120px;
    height: 120px;
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 30px;
    font-size: 50px;
    color: #667eea;
}

.empty-state h2 {
    font-size: 28px;
    color: #333;
    margin-bottom: 15px;
}

.empty-state p {
    font-size: 16px;
    color: #666;
    margin-bottom: 30px;
}

/* Schedule Grid */
.schedule-grid {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.session-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
    display: flex;
    overflow: hidden;
    transition: all 0.3s;
}

.session-card:hover {
    transform: translateX(5px);
    box-shadow: 0 15px 40px rgba(102, 126, 234, 0.15);
}

.session-date {
    width: 100px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    padding: 20px 0;
}

.session-date .day {
    font-size: 36px;
    font-weight: 800;
    line-height: 1;
}

.session-date .month {
    font-size: 18px;
    font-weight: 600;
    text-transform: uppercase;
    margin-top: 5px;
}

.session-content {
    flex: 1;
    padding: 25px;
}

.session-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 15px;
}

.session-title {
    font-size: 20px;
    font-weight: 700;
    color: #333;
    margin: 0;
}

.session-category {
    display: inline-block;
    padding: 6px 14px;
    background: linear-gradient(135deg, #667eea15 0%, #764ba215 100%);
    color: #667eea;
    border-radius: 50px;
    font-size: 12px;
    font-weight: 600;
}

.session-details {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
    margin-bottom: 20px;
}

.session-detail {
    display: flex;
    align-items: center;
    gap: 10px;
    color: #666;
    font-size: 14px;
}

.session-detail i {
    width: 18px;
    color: #667eea;
}

.session-detail .price {
    font-weight: 700;
    color: #28a745;
}

.session-actions {
    display: flex;
    justify-content: flex-end;
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 24px;
    font-size: 14px;
    font-weight: 600;
    text-decoration: none;
    border-radius: 12px;
    border: none;
    cursor: pointer;
    transition: all 0.3s;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
}

.btn-secondary {
    background: #e0e0e0;
    color: #666;
    cursor: not-allowed;
}

/* Responsive */
@media (max-width: 768px) {
    .schedule-header {
        padding: 40px 0;
    }
    
    .schedule-title {
        font-size: 28px;
    }
    
    .session-card {
        flex-direction: column;
    }
    
    .session-date {
        width: 100%;
        flex-direction: row;
        gap: 10px;
        padding: 15px;
    }
    
    .session-date .day {
        font-size: 24px;
    }
    
    .session-header {
        flex-direction: column;
        gap: 10px;
    }
    
    .session-details {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 480px) {
    .schedule-title {
        font-size: 24px;
    }
    
    .session-content {
        padding: 20px;
    }
    
    .session-actions {
        justify-content: stretch;
    }
    
    .session-actions .btn {
        width: 100%;
    }
}
</style>